#ifndef M68000_CYCLONE_H
#define M68000_CYCLONE_H
#include "cyclone.h"

#if defined(__cplusplus) && !defined(USE_CPLUS)
extern "C" {
#endif

extern struct Cyclone cyclone;
#define MC68000_ICount (cyclone.cycles)

#ifndef M68000_H

typedef struct
{
	struct Cyclone regs;
	int pending_interrupts;
} MC68000_Regs;

extern void MC68000_Reset(void);                      
extern int  MC68000_Execute(int);                     
extern void MC68000_SetRegs(MC68000_Regs *);          
extern void MC68000_GetRegs(MC68000_Regs *);          
extern void MC68000_Cause_Interrupt(int);             
extern void MC68000_Clear_Pending_Interrupts(void);   
extern int  MC68000_GetPC(void);                      


#define MC68000_INT_NONE 0							  
#define MC68000_IRQ_1    1
#define MC68000_IRQ_2    2
#define MC68000_IRQ_3    3
#define MC68000_IRQ_4    4
#define MC68000_IRQ_5    5
#define MC68000_IRQ_6    6
#define MC68000_IRQ_7    7

#define MC68000_STOP     0x10
#endif

#if defined(__cplusplus) && !defined(USE_CPLUS)
}
#endif

#endif
